import { RouteInfo } from './sidebar.metadata';

export const ROUTES: RouteInfo[] = [
  {
    path: 'dashboard',
    title: 'DASHBOARD',
    icon: 'layers',
    class: '',
    groupTitle: false,
    claims: ['DASHBOARD_VIEW_DASHBOARD'],
    submenu: [],
  },
  {
    path: '',
    title: 'ASSIGNED_DOCUMENTS',
    icon: 'list',
    class: '',
    groupTitle: false,
    claims: [],
    submenu: [],
  },
  {
    path: 'documents',
    title: 'ALL_DOCUMENTS',
    icon: 'file-text',
    class: '',
    groupTitle: false,
    claims: ['ALL_DOCUMENTS_VIEW_DOCUMENTS'],
    submenu: [],
  },
  {
    path: 'documents/deep-search',
    title: 'DEEP_SEARCH',
    icon: 'zoom-in',
    class: '',
    groupTitle: false,
    claims: ['DEEP_SEARCH_DEEP_SEARCH'],
    submenu: [],
  },
  {
    path: '',
    title: 'AI_DOCUMENTS',
    icon: 'cpu',
    class: 'menu-toggle',
    groupTitle: false,
    claims: ['GENERATE_AI_DOCUMENTS', 'MANAGE_AI_PROMPT_TEMPLATES', 'VIEW_AI_GENERATED_DOCUMENTS'],
    submenu: [
      {
        path: 'ai-document-generator',
        title: 'AI_DOCUMENT_GENERATOR',
        icon: 'cpu',
        class: 'ml-menu',
        groupTitle: false,
        claims: ['GENERATE_AI_DOCUMENTS'],
        submenu: [],
      },
      {
        path: 'ai-document-generator-list',
        title: 'AI_DOCUMENT_LIST',
        icon: 'cpu',
        class: 'ml-menu',
        groupTitle: false,
        claims: ['VIEW_AI_GENERATED_DOCUMENTS'],
        submenu: [],
      }, {
        path: 'ai-template',
        title: 'AI_PROMPT_TEMPLATES',
        icon: 'email',
        class: 'ml-menu',
        groupTitle: false,
        claims: ['MANAGE_AI_PROMPT_TEMPLATES'],
        submenu: [],
      }
    ],
  },
  {
    path: 'bulk-document-upload',
    title: 'BULK_DOCUMENT_UPLOAD',
    icon: 'upload',
    class: '',
    groupTitle: false,
    claims: ['BULK_DOCUMENT_UPLOAD'],
    submenu: [],
  },
  {
    path: 'document-audit-trails',
    title: 'DOCUMENTS_AUDIT_TRAIL',
    icon: 'activity',
    class: '',
    groupTitle: false,
    claims: ['DOCUMENT_AUDIT_TRAIL_VIEW_DOCUMENT_AUDIT_TRAIL'],
    submenu: [],
  },
  {
    path: 'archived-documents',
    title: 'ARCHIVED_DOCUMENTS',
    icon: 'archive',
    class: '',
    groupTitle: false,
    claims: ['ARCHIVE_DOCUMENT_VIEW_DOCUMENTS'],
    submenu: [],
  },
  {
    path: 'file-request',
    title: 'FILE_REQUEST',
    icon: 'inbox',
    class: '',
    groupTitle: false,
    claims: ['FILE_REQUEST_VIEW_FILE_REQUEST'],
    submenu: [],
  },
  {
    path: 'categories',
    title: 'DOCUMENT_CATEGORIES',
    icon: 'file',
    class: '',
    groupTitle: false,
    claims: ['DOCUMENT_CATEGORY_MANAGE_DOCUMENT_CATEGORY'],
    submenu: [],
  },
  {
    path: 'document-status',
    title: 'DOCUMENT_STATUS',
    icon: 'check',
    class: '',
    groupTitle: false,
    submenu: [],
    claims: ['MANAGE_DOCUMENT_STATUS']
  },
  {
    path: 'client',
    title: 'CLIENTS',
    icon: 'users',
    class: '',
    groupTitle: false,
    claims: ['CLIENTS_MANAGE_CLIENTS'],
    submenu: [],
  },
  {
    path: 'roles',
    title: 'ROLES',
    icon: 'users',
    class: '',
    groupTitle: false,
    claims: ['ROLE_VIEW_ROLES'],
    submenu: [],
  },
  {
    path: 'users',
    title: 'USERS',
    icon: 'user',
    class: '',
    groupTitle: false,
    claims: ['USER_VIEW_USERS'],
    submenu: [],
  },
  {
    path: 'roles/users',
    title: 'ROLE_USER',
    icon: 'user-check',
    class: '',
    groupTitle: false,
    claims: ['USER_ASSIGN_USER_ROLE'],
    submenu: [],
  },
  {
    path: 'reminders',
    title: 'REMINDER',
    icon: 'bell',
    class: '',
    groupTitle: false,
    claims: ['REMINDER_VIEW_REMINDERS'],
    submenu: [],
  },
  {
    path: 'login-audit',
    title: 'LOGIN_AUDITS',
    icon: 'log-in',
    class: '',
    groupTitle: false,
    claims: ['LOGIN_AUDIT_VIEW_LOGIN_AUDIT_LOGS'],
    submenu: [],
  },
  {
    path: '',
    title: 'SETTINGS',
    icon: 'settings',
    class: 'menu-toggle',
    groupTitle: false,
    claims: [
      'EMAIL_MANAGE_SMTP_SETTINGS',
      'SETTING_MANAGE_PROFILE',
      'SETTING_MANAGE_LANGUAGE',
      'SETTINGS_STORAGE_SETTINGS',
      'PAGE_HELPER_MANAGE_PAGE_HELPER',
      'SETTINGS_MANAGE_ALLOW_FILE_EXTENSIONS'
    ],
    submenu: [
      {
        path: 'email-smtp',
        title: 'SMTP_SETTING',
        icon: 'mail',
        class: 'ml-menu',
        groupTitle: false,
        claims: ['EMAIL_MANAGE_SMTP_SETTINGS'],
        submenu: [],
      },
      {
        path: 'company-profile',
        title: 'COMPANY_PROFILE',
        icon: 'mail',
        class: 'ml-menu',
        groupTitle: false,
        claims: ['SETTING_MANAGE_PROFILE', 'SETTINGS_STORAGE_SETTINGS', 'SETTINGS_MANAGE_OPEN_AI_API_KEY'],
        submenu: [],
      },
      {
        path: 'allow-file-extension',
        title: 'ALLOW_FILE_EXTENSIONS',
        icon: 'mail',
        class: 'ml-menu',
        groupTitle: false,
        claims: ['SETTINGS_MANAGE_ALLOW_FILE_EXTENSIONS'],
        submenu: [],
      },
      {
        path: 'languages',
        title: 'LANGUAGES',
        icon: '',
        class: 'ml-menu',
        groupTitle: false,
        submenu: [],
        claims: ['SETTING_MANAGE_LANGUAGE'],
      },
      {
        path: 'page-helper',
        title: 'PAGE_HELPER',
        icon: '',
        class: 'ml-menu',
        groupTitle: false,
        submenu: [],
        claims: ['PAGE_HELPER_MANAGE_PAGE_HELPER'],
      },
    ],
  },
];
